<?php
// PHP Backend Logic (This part is the same as the last version)
error_reporting(0);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'migrate_schema') {
    header('Content-Type: application/json');

    if (!file_exists('config.php')) {
        echo json_encode(['success' => false, 'error' => 'فایل config.php یافت نشد. لطفاً مطمئن شوید ربات طبق مراحل نصب شده است.']);
        exit;
    }

    include 'config.php';
    $connection = new mysqli('localhost', $username, $password, $dbname);

    if ($connection->connect_error) {
        echo json_encode(['success' => false, 'error' => 'خطا در اتصال به دیتابیس: ' . $connection->connect_error]);
        exit;
    }

    $migration_queries = [
        // Update `user` table structure
        "ALTER TABLE `user` MODIFY `step` TEXT NOT NULL, MODIFY `step2` TEXT NOT NULL, MODIFY `step3` TEXT NOT NULL, MODIFY `step4` TEXT NOT NULL, MODIFY `step5` TEXT NOT NULL;",
        "ALTER TABLE `user` MODIFY `dl` INT(20) DEFAULT NULL;",
        "ALTER TABLE `user` MODIFY `name` VARCHAR(150) DEFAULT NULL;",
        "ALTER TABLE `user` MODIFY `timejoin` VARCHAR(100) DEFAULT NULL;",
        "ALTER TABLE `user` CONVERT TO CHARACTER SET latin1 COLLATE latin1_swedish_ci;",

        // Update `files` table structure
        "ALTER TABLE `files` ADD `media_group_id` mediumtext DEFAULT NULL AFTER `fwlock`;",
        "ALTER TABLE `files` ADD `backup_status` varchar(20) DEFAULT 'none' AFTER `media_group_id`;",
        "ALTER TABLE `files` ADD `cover_id` varchar(255) DEFAULT NULL AFTER `backup_status`;",
        "ALTER TABLE `files` MODIFY `file_id` mediumtext DEFAULT NULL;",
        "ALTER TABLE `files` MODIFY `caption` mediumtext DEFAULT NULL;",
        "ALTER TABLE `files` MODIFY `thumbnail` mediumtext DEFAULT NULL;",
        "ALTER TABLE `files` MODIFY `dl` INT(20) DEFAULT NULL;",
        "ALTER TABLE `files` MODIFY `type` VARCHAR(15) DEFAULT NULL;",
        "ALTER TABLE `files` MODIFY `file` int(10) NOT NULL AUTO_INCREMENT;",
        
        // Migrate `userfiles` table
        "RENAME TABLE `userfiles` TO `userfiles_old`;",
        "CREATE TABLE `userfiles` (
          `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY, `code` varchar(20) NOT NULL, `user_id` bigint(20) NOT NULL,
          `file_id` text NOT NULL, `file_size` varchar(50) DEFAULT NULL, `caption` text DEFAULT NULL,
          `type` varchar(20) NOT NULL, `media_group_id` varchar(100) DEFAULT NULL, `upload_time` varchar(50) NOT NULL,
          `status` enum('pending','approved','rejected') DEFAULT 'pending', `admin_id` bigint(20) DEFAULT NULL,
          `action_time` varchar(50) DEFAULT NULL, KEY `code_idx` (`code`), KEY `user_id_idx` (`user_id`),
          KEY `status` (`status`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;",
        "INSERT INTO `userfiles` (code, user_id, file_id, caption, type, upload_time, status)
         SELECT code, id, file_id, caption, type, NOW(), 'approved'
         FROM `userfiles_old`;",
        "DROP TABLE `userfiles_old`;"
    ];

    foreach ($migration_queries as $query) {
        if (!$connection->query($query)) {
            $error_code = $connection->errno;
            // 1060: Duplicate column, 1050: Table exists, 1061: Duplicate key, 1146: Table doesn't exist (e.g. userfiles_old)
            if (in_array($error_code, [1060, 1050, 1061, 1146])) {
                continue; 
            }
            echo json_encode([
                'success' => false,
                'error' => "خطا در اجرای دستور SQL: <br><pre>" . htmlspecialchars($query) . "</pre><br><strong>پیام خطا:</strong> " . $connection->error
            ]);
            $connection->close();
            exit;
        }
    }

    $connection->close();
    echo json_encode([
        'success' => true,
        'message' => '🎉 ساختار تمام جداول با موفقیت به نسخه ۴ ارتقاء یافت و اطلاعات شما حفظ شد.'
    ]);
    exit;
}
?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>راهنمای ارتقاء به نسخه ۴ ربات آپلودر</title>
    <style>
        @font-face { font-family: 'IRANYekanX'; src: url('pay/IRANYekanX-Bold.ttf') format('truetype'); font-weight: bold; }
        * { font-family: 'IRANYekanX', Tahoma, Arial, sans-serif; margin: 0; padding: 0; box-sizing: border-box; }
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px; }
        .container { max-width: 900px; margin: 40px auto; background: rgba(255, 255, 255, 0.98); border-radius: 25px; box-shadow: 0 25px 50px rgba(0,0,0,0.2); overflow: hidden; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; text-align: center; padding: 40px 20px; }
        .header h1 { font-size: 2.5em; margin-bottom: 10px; }
        .logo-icon { font-size: 4em; margin-bottom: 20px; }
        .content { padding: 40px; }
        .step { display: none; }
        .step.active { display: block; animation: fadeIn 0.5s; }
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        .step h2 { color: #2c3e50; margin-bottom: 25px; font-size: 1.8em; display: flex; align-items: center; gap: 15px; }
        .step-number { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; min-width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 1.2em; }
        .btn { background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); color: white; border: none; padding: 15px 35px; border-radius: 50px; cursor: pointer; font-size: 18px; font-weight: bold; margin-top: 20px; transition: all 0.3s ease; }
        .btn:hover { transform: translateY(-2px); box-shadow: 0 8px 15px rgba(0,0,0,0.1); }
        .btn:disabled { background: #6c757d; cursor: not-allowed; }
        .btn-success { background: linear-gradient(135deg, #28a745 0%, #218838 100%); }
        .alert { padding: 20px; margin: 20px 0; border-radius: 15px; border-left: 5px solid; text-align: right; line-height: 1.8; }
        .alert-info { background: #d1ecf1; border-color: #007BFF; color: #0c5460; }
        .alert-warning { background: #fff3cd; border-color: #ffc107; color: #856404; }
        .alert-success { background: #d4edda; border-color: #28a745; color: #155724; }
        .alert-error { background: #f8d7da; border-color: #dc3545; color: #721c24; }
        .loader { border: 5px solid #f3f3f3; border-radius: 50%; border-top: 5px solid #667eea; width: 40px; height: 40px; animation: spin 1s linear infinite; margin: 20px auto; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        ul, ol { padding-right: 25px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo-icon">🚀</div>
            <h1>راهنمای ارتقاء به نسخه ۴</h1>
            <p>لطفاً مراحل را با دقت دنبال کنید.</p>
        </div>
        <div class="content">

            <div id="step1" class="step active">
                <h2><span class="step-number">۱</span>معرفی فرآیند</h2>
                <div class="alert alert-info">
                    <p>سلام! به راهنمای ارتقاء ربات آپلودر به نسخه ۴ خوش آمدید.</p>
                    <p>این فرآیند به شما کمک می‌کند تا تمام اطلاعات مهم ربات قدیمی خود شامل **کاربران**، **فایل‌های آپلود شده توسط ادمین** و **فایل‌های آپلود شده توسط کاربران** را به نسخه جدید منتقل کنید.</p>
                </div>
                <button class="btn" onclick="showStep(2)">مرحله بعد</button>
            </div>

            <div id="step2" class="step">
                <h2><span class="step-number">۲</span>تهیه بکاپ از دیتابیس قدیمی</h2>
                <div class="alert alert-warning">
                    <p>در این مرحله، باید از سه جدول مهم در دیتابیس **نسخه قدیمی (نسخه ۳)** خود یک خروجی (بکاپ) با فرمت SQL تهیه کنید.</p>
                    <strong>روش تهیه خروجی (Export):</strong>
                    <ol>
                        <li>وارد phpMyAdmin هاست قدیمی خود شوید و دیتابیس مربوط به ربات را انتخاب کنید.</li>
                        <li>به تب <strong>Export</strong> بروید.</li>
                        <li>روش خروجی (Export method) را روی <strong>Custom</strong> قرار دهید.</li>
                        <li>در لیست جداول، فقط سه جدول <strong>`user`</strong>, <strong>`files`</strong> و <strong>`userfiles`</strong> را انتخاب کنید.</li>
                        <li>مطمئن شوید فرمت خروجی <strong>SQL</strong> باشد. سپس روی دکمه <strong>"Go"</strong> یا "Export" کلیک کرده و فایل را دانلود کنید.</li>
                    </ol>
                </div>
                <button class="btn" onclick="showStep(3)">انجام دادم، برو به مرحله بعد</button>
            </div>

            <div id="step3" class="step">
                <h2><span class="step-number">۳</span>نصب نسخه جدید ربات</h2>
                <div class="alert alert-info">
                    <p>حالا باید نسخه جدید ربات را با استفاده از فایل `installer.php` نصب کنید.</p>
                    <strong>نکات بسیار مهم:</strong>
                    <ul>
                        <li>برای نصب، یک <strong>دیتابیس جدید و کاملاً خالی</strong> در هاست خود بسازید.</li>
                        <li>هنگام نصب، از همان <strong>توکن ربات</strong> و <strong>آیدی عددی ادمین</strong> قبلی استفاده کنید.</li>
                    </ul>
                </div>
                <button class="btn" onclick="showStep(4)">انجام دادم، برو به مرحله بعد</button>
            </div>

            <div id="step4" class="step">
                <h2><span class="step-number">۴</span>حذف جداول از دیتابیس جدید</h2>
                <div class="alert alert-warning">
                    <p>برای اینکه بتوانیم اطلاعات قدیمی را وارد کنیم، ابتدا باید جداول مشابهی که توسط نصب‌کننده جدید ایجاد شده‌اند را حذف کنیم.</p>
                     <ol>
                        <li>وارد phpMyAdmin هاست شوید و دیتابیس <strong>جدیدی</strong> که در مرحله قبل ساختید را انتخاب کنید.</li>
                        <li>جداول <strong>`user`</strong>, <strong>`files`</strong> و <strong>`userfiles`</strong> را پیدا کنید.</li>
                        <li>آنها را انتخاب کرده و از طریق گزینه <strong>Drop</strong> (حذف) به طور کامل پاک کنید.</li>
                    </ol>
                </div>
                <button class="btn" onclick="showStep(5)">انجام دادم، برو به مرحله بعد</button>
            </div>

            <div id="step5" class="step">
                <h2><span class="step-number">۵</span>وارد کردن بکاپ قدیمی</h2>
                <div class="alert alert-info">
                    <p>حالا زمان آن است که بکاپی که در مرحله ۲ گرفتید را در دیتابیس جدید وارد (Import) کنید.</p>
                    <ol>
                        <li>در همان دیتابیس جدید، به تب <strong>Import</strong> بروید.</li>
                        <li>روی دکمه <strong>"Choose File"</strong> کلیک کرده و فایل `.sql` که دانلود کرده بودید را انتخاب کنید.</li>
                        <li>روی دکمه <strong>"Go"</strong> یا "Import" در پایین صفحه کلیک کنید و منتظر بمانید تا عملیات با موفقیت انجام شود.</li>
                    </ol>
                </div>
                <button class="btn" onclick="showStep(6)">انجام دادم، برو به مرحله نهایی</button>
            </div>

            <div id="step6" class="step">
                <h2><span class="step-number">۶</span>ارتقاء نهایی ساختار دیتابیس</h2>
                <div class="alert alert-info">
                    <p>شما تمام مراحل آماده‌سازی را با موفقیت انجام دادید! دیتابیس شما اکنون حاوی اطلاعات قدیمی با ساختار قدیمی است.</p>
                    <p>با کلیک روی دکمه زیر، این اسکریپت ساختار جداول را به نسخه ۴ ارتقاء می‌دهد، بدون اینکه هیچ داده‌ای حذف شود.</p>
                </div>
                <button class="btn btn-success" id="start-btn" onclick="startMigration()">🚀 شروع ارتقاء ساختار</button>
                <div id="result-area" style="margin-top: 20px; display: none;">
                     <div id="loader" class="loader"></div>
                     <div id="result-message"></div>
                </div>
            </div>

        </div>
    </div>
    <script>
        function showStep(stepNumber) {
            document.querySelectorAll('.step').forEach(el => el.classList.remove('active'));
            document.getElementById('step' + stepNumber).classList.add('active');
        }

        async function startMigration() {
            const startBtn = document.getElementById('start-btn');
            const resultArea = document.getElementById('result-area');
            const loader = document.getElementById('loader');
            const resultMessage = document.getElementById('result-message');

            startBtn.disabled = true;
            startBtn.textContent = 'در حال انجام عملیات...';
            resultArea.style.display = 'block';
            resultMessage.innerHTML = '';

            const formData = new FormData();
            formData.append('action', 'migrate_schema');

            try {
                const response = await fetch('update.php', { method: 'POST', body: formData });
                const result = await response.json();
                
                if(result.success) {
                    resultMessage.innerHTML = `<div class="alert alert-success"><h3>موفقیت‌آمیز!</h3><p>${result.message}</p><p style="color:red; margin-top:15px; font-weight:bold;">نکته بسیار مهم: برای امنیت، همین حالا فایل update.php را از هاست خود حذف کنید.</p></div>`;
                } else {
                    resultMessage.innerHTML = `<div class="alert alert-error"><h3>خطا!</h3><p>${result.error}</p></div>`;
                }

            } catch (error) {
                 resultMessage.innerHTML = `<div class="alert alert-error"><h3>خطای جاوا اسکریپت!</h3><p>پاسخ معتبری از سرور دریافت نشد. لطفاً از طریق ابزار توسعه‌دهنده مرورگر (F12 -> Network) پاسخ سرور را بررسی کنید. خطا: ${error.message}</p></div>`;
            } finally {
                loader.style.display = 'none';
                startBtn.style.display = 'none';
            }
        }
    </script>
</body>
</html>